﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Xml.Linq;
using System.Web.Mvc;
using System.Xml.Xsl;
using System.IO;

namespace r13.Engines
{
    public class XSLTView : IView
    {
        private readonly XslCompiledTransform _template;

        public XSLTView(ControllerContext controllerContext, string viewPath)
        {
            // Załadowanie szablonu widoku
            _template = new XslCompiledTransform();
            _template.Load(controllerContext.HttpContext.Server.MapPath(viewPath));
        }

        public void Render(ViewContext viewContext, TextWriter writer)
        {
            // Sprawdzenie, czy przychodzące dane ViewData są prawidłowe
            XDocument xmlModel = viewContext.ViewData.Model as XDocument;
            if (xmlModel == null)
                throw new ArgumentException("ViewData.Model busi być typu XDocument");

            // Uruchomienie transformacji bezpośrednio do strumienia wyjściowego 
            _template.Transform(xmlModel.CreateReader(), null, writer);
        }
    } 

}
